-- mods/aluminum/init.lua
-- ===================
-- See LICENSE.txt for licensing and README.md for other information.

-- load support for intllib
local modpath = minetest.get_modpath(minetest.get_current_modname())
local S = minetest.get_translator("aluminum")

-- Lapis Lazuli Ore
minetest.register_node("aluminum:stone_with_aluminum", {
	description = S("aluminum Ore"),
	tiles = {"default_stone.png^aluminum_mineral_aluminum.png"},
	is_ground_content = true,
	groups = {cracky=2},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'aluminum:aluminum 2'},  --The first and second drops ever
			},
			{
				items = {'aluminum:aluminum'},    --The 3rd drops with a 1/2 chance
				rarity = 2,
			},
			{
				items = {'aluminum:aluminum'},    --The 4th drops with a 1/3 chance
				rarity = 2,
			},
			{
				items = {'aluminum:aluminum'},    --The 5th drops with a 1/8 chance
				rarity = 2,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})

-- Lapis Item
minetest.register_craftitem("aluminum:aluminum", {
	description = S("aluminum"),
	inventory_image = "aluminum.png",
})


minetest.register_node("aluminum:aluminumblock", {
	description = S("aluminum Block"),
	tiles = {"aluminum_aluminumblock.png"},
	is_ground_content = true,
	groups = {cracky = 1, level = 2},
	sounds = default.node_sound_stone_defaults(),
})


minetest.register_craft({
	output = 'aluminum:aluminum',
	recipe = {
		{'aluminum:aluminum', 'aluminum:aluminum', 'aluminum:aluminum'},
		{'aluminum:aluminum', 'aluminum:aluminum', 'aluminum:aluminum'},
		{'aluminum:aluminum', 'aluminum:aluminum', 'aluminum:aluminum'},
	}
})

-- Lapis Items from Lapis Block Crafting
minetest.register_craft({
	output = 'aluminum:aluminum 9',
	recipe = {
		{'aluminum:aluminum'},
	}
})

-- Ore generation
-- -128 <-> -255
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "aluminum:stone_with_aluminum",
	wherein        = "default:stone",
	clust_scarcity = 16 * 16 * 16,
	clust_num_ores = 5,
	clust_size     = 3,
	height_min     = -31000,
	height_max     = 31000,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "aluminum:stone_with_aluminum",
	wherein        = "default:stone",
	clust_scarcity = 15 * 15 * 15,
	clust_num_ores = 6,
	clust_size     = 4,
	height_min     = -31000,
	height_max     = 31000,
})


